<?php
	defined( 'ABSPATH' ) || exit;
?>

<!-- Complete -->

<div class="mfn-dashboard-card mfn-setup-card card-complete" data-step="complete">

  <div class="card-header">
    <h2>اتمام تنظیمات اولیه</h2>
    <p>داده های انتخاب شده در مرحله قبل را وارد خواهد کرد. ابتدا باید افزونه های لازم را نصب و فعال کنید.</p>
  </div>

  <div class="card-content">

    <a class="mfn-btn mfn-btn-blue btn-large setup-complete">شروع نصب</a>

    <div class="card-columns">

      <div class="column left">
        <ul class="complete-steps">
          <li class="reset hidden" data-action="reset">ریست کردن دیتابیس</li>

          <?php
            foreach( $this->plugins as $plugin_key => $plugin ){
              $class = $plugin_key;

              if( empty( $plugin['action'] ) ){
                echo '<li class="plugin done '. esc_attr($class) .'" data-action="">Plugin: '. esc_attr($plugin['name']) .'</li>';
              } elseif( 'activate' == $plugin['action'] ){
                echo '<li class="plugin '. esc_attr($class) .'" data-plugin="'. esc_attr($plugin['slug']) .'" data-path="'. esc_attr($plugin['path']) .'" data-action="plugin-activate">Plugin: '. esc_attr($plugin['name']) .'</li>';
              } elseif( 'install' == $plugin['action'] ){
                echo '<li class="plugin '. esc_attr($class) .'" data-plugin="'. esc_attr($plugin['slug']) .'" data-page="'. apply_filters('betheme_slug', 'be') .'-tgmpa' .'" data-action="plugin-install">Plugin: '. esc_attr($plugin['name']) .'</li>';
              }

            }
          ?>

          <li class="download pre" data-action="download">دریافت پکیج دمو</li>
          <li class="content pre" data-action="content">محتوی اصلی</li>
          <li class="options" data-action="options">تنظیمات قالب</li>
          <li class="slider pre" data-action="slider">اسلایدر ها</li>
          <li class="settings" data-action="settings">تنظیمات سایت</li>

        </ul>
      </div>

      <div class="column right">
        <img class="website-image" src="https://muffingroup.com/betheme/assets/images/demos/theme.jpg" alt="Pre-built website"/>
      </div>

    </div>

  </div>

	<div class="card-hidden hidden">
		<?php // DO NOT delete this div, fallback for 524 timeout images on last screen ?>
		<span class="mfn-icon-yes-green"></span>
	</div>

</div>
